
Network devices generate logging messages about network activity and device events, which are then managed by a logging subsystem. This subsystem controls where these messages are sent, such as to a logging buffer, terminal lines, or a UNIX syslog server, based on the configuration.


### Device and Network Events Logging

- **Purpose of Logging**: Logging of device and network events serves several critical functions:
    
    - Device failure notifications
    - Network telemetry and forensics
    - Security audits
- **Message Filtering**:
    
    - Before distribution, the logging subsystem filters messages, typically based on **message severity levels**.
    - Cisco Secure Firewall ASA and Cisco Secure Firewall Threat Defense devices offer advanced filtering options using **event classes** or **custom message lists**.
- **Centralized Logging**:
    
    - Sending logs to a central syslog server helps in aggregating logs and alerts.
    - Syslog services accept messages and store them in files, providing protected long-term storage for troubleshooting, security audits, and incident handling.

### Logging Destinations

Cisco devices support various logging destinations:

- **Common Cisco Devices (e.g., Cisco IOS XE, Cisco Secure Firewall ASA/Threat Defense)**:
    
    - **Console**: Low-bandwidth serial connection for system log messages within the console CLI session.
    - **Telnet or Secure Shell (SSH) Administrative Sessions**: Requires explicit enablement for logging over these connections.
    - **Internal In-Memory Buffer**: Stores a snapshot of recent activity; not persistent across reboots.
    - **Remote Syslog Servers**: Cisco devices use the standard UNIX syslog protocol (UDP port 514) to send events.
- **Cisco Secure Firewall ASA and Cisco Secure Firewall Threat Defense Specific Destinations**:
    
    - **Remote Network Management Servers**: Uses standard Simple Network Management Protocol (SNMP) traps to send events.
    - **Cisco Adaptive Security Device Manager (ASDM) GUI (ASA only)**: Provides an event viewer for real-time monitoring and troubleshooting.
    - **Email Systems**: Uses standard Simple Mail Transport Protocol (SMTP) to send events to defined email servers.

### Message Severity Levels

Each system message is assigned a severity level:

- **0 — Emergencies**: System unusable messages.
- **1 — Alerts**: Immediate action required.
- **2 — Critical**: Critical condition.
- **3 — Errors**: Error message.
- **4 — Warnings**: Warning message.
- **5 — Notifications**: Normal but significant condition.
- **6 — Informational**: Informational message.
- **7 — Debugging**: Debug message or very detailed accounting message.

### Syslog Message Format

A typical syslog message consists of:

- **Timestamp**: Disabled by default.
- **Device ID**: Disabled by default; can include interface name, IP address, hostname, context name, or custom string (up to 16 characters).
- **Message Identifier**: E.g., `%ASA-7-111009` (device type, severity, event number).
- **Message Text**: E.g., `user "administrator" executed cmd: show interface`.

### System Logging Guidelines

- **Log Retention Policy**: Create and enforce a policy for log retention.
- **Logging Levels**:
    - **Regular Operations**: Set to "Informational" (6) to avoid excessive data.
    - **Troubleshooting**: Temporarily set to "Debug" (7).
    - **Performance Issues**: Set to "Notice" (5) or higher.
- **Multiple Destinations**: Use multiple logging destinations for reliability and dual control.
- **Monitor Logging Subsystem**: Regularly check for anomalies or major problems (e.g., disabled logging).
- **Protect Remote Destinations**: Secure remote logging servers.
- **Limited Access**: Restrict access to the device logging subsystem to prevent unauthorized disabling or tampering. Implement mechanisms (e.g., ACLs, cryptographic checksums, digital signatures) to prevent or detect changes to stored event data.

### Logging on Cisco Secure Firewall Threat Defense

- **Logging Destinations**:
    - Cisco Secure Firewall Management Center (FMC) database (Event Viewer).
    - External syslog or SNMP trap server via an alert response.
- **Benefits of Logging to FMC Database**:
    - **Dashboards and Context Explorer**: Graphical overviews of connections.
    - **Event Views**: Detailed information in graphical, tabular, or report formats.
    - **Traffic Profiling**: Baselines for detecting anomalous behavior.
    - **Correlation Policies**: Generate events and trigger responses to specific connections or traffic changes.
    - _Note_: Critical connections (logged intrusions, prohibited files, malware) are automatically logged to FMC.
- **Configuration Considerations**:
    - Connection and security events are _not_ sent to FMC by default; logging must be enabled in the access control policy rule.
    - ASA (LINA) engine logs can be sent directly to a syslog or SNMP server from within Threat Defense.
    - Logs can be sent from FMC using syslog, SNMP, or eStreamer.
    - Threat Defense logs (ASA engine logs only) can be accessed directly via CLI using `show logging`.
- **Customising Syslog Events**:
    - **Configure Event Lists**: Create/edit event lists to filter log data.
    - **Rate limit**: Define message rates to all destinations and assign severity.
    - **Syslog settings**: Configure Facility values, include timestamps, and other server-specific parameters.
    - **Logging Destination**: Configure specific logging destinations.
    - **Email Setup**: Send syslog messages to email addresses.
- **Local vs. External Logging**:
    - **Local Logging**: Console, internal buffer, SSH session logging; useful for live troubleshooting.
    - **External Logging**: External syslog server, email relay server, SNMP traps; useful for log correlation and incident handling.
- **Cisco Event Streamer (eStreamer)**:
    - Allows streaming FMC events (host, discovery, correlation, intrusion, user activity, file, malware, connection data) to external client applications (e.g., Splunk).
    - **Configuration Steps**:
        1. Develop a client application (SDK includes reference client).
        2. Configure FMC to send required event types.
        3. Connect client application to FMC.
    - Enabled via `Integration > Other Integrations > eStreamer` on FMC.
- **Connection Events**:
    - Logs generated by managed devices about detected sessions.
    - **Properties**: Timestamp, source/destination IP, zones, handling device, applications, URLs, users, and metadata (e.g., why logged, allowed/blocked, encryption details).
    - **Granularity**: Log connections based on security and compliance needs; can be enabled per-rule within parent policies.
    - Some events (e.g., detected files, malware, intrusions) are automatically logged even if connection event storage is disabled elsewhere.

### Logging on Cisco Secure Email Gateway and Cisco Secure Web Appliance

- **Purpose**: Record system and traffic management activities for monitoring and troubleshooting.
- **Log File Subscriptions**:
    - Define settings for creating, customizing, and managing log files.
    - Multiple subscriptions can be created for each log type, including archiving and storage details.
    - Default subscriptions exist (e.g., "Default Proxy Logs" for Web Appliance).
- **Log Types**: Messages can be message data, system statistics, binary, or textual.
- **Log Retrieval Methods**:
    - **Manually Download**: Access via HTTPS link (default).
    - **FTP Push**: Periodically pushes log files to an FTP server based on a rollover schedule.
    - **Secure Copy Protocol (SCP) Push**: Periodically pushes log files to an SCP server (SSHv1/v2) based on a rollover schedule.
    - **Syslog Push**: Sends text-based log messages to a remote syslog server (UDP/TCP port 514, RFC 3164).
- **Log File Naming**: `/LogSubscriptionName/LogFilename.@timestamp.statuscode` (e.g., `.current`, `.s`).

### Use Case: Configure Logging on Cisco IOS XE Device

- **Configuration Tasks**:
    - Globally enable logging: `logging on` (often enabled by default).
    - Configure logging to buffer: `logging buffered informational` (logs level 6 and lower).
    - Configure logging to syslog server: `logging trap debugging` (logs level 7 and lower), `logging host 172.16.200.51`.
- **Verification**: `show logging` command.

### Use Case: Logging Subscriptions on Cisco Secure Email Gateway

- **Configuration Steps**:
    - Navigate to `System Administration > Log Subscriptions`.
    - Click `Add Log Subscription`.
    - Choose log type, enter log name and file name.
    - Configure max file size, rollover interval, and retrieval method.
    - Submit and commit changes.
- **Global Settings**: Configure system measurement frequency, inclusion of Message-ID headers, remote response, original subject header, and other custom headers via `System Administration > Log Subscriptions > Global Settings`.

### Use Case: Configure Logging on Cisco Secure Firewall ASA and Cisco Secure Firewall Threat Defense

- **Cisco Secure Firewall ASA**: Configure logging (e.g., severity debugging and lower) to a syslog server using Cisco ASDM.
- **Cisco Secure Firewall Threat Defense**:
    - Configure ASA engine logs to a syslog server.
    - Configure access control policy to log connection events to the same syslog server via Cisco Secure Firewall Management Center.